/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.backends.common;

import com.inprise.vbroker.compiler.ast.AliasNode;
import com.inprise.vbroker.compiler.ast.AttributeNode;
import com.inprise.vbroker.compiler.ast.ConstantNode;
import com.inprise.vbroker.compiler.ast.ContainedNode;
import com.inprise.vbroker.compiler.ast.ContainerNode;
import com.inprise.vbroker.compiler.ast.EnumNode;
import com.inprise.vbroker.compiler.ast.ExceptionNode;
import com.inprise.vbroker.compiler.ast.InheritableNode;
import com.inprise.vbroker.compiler.ast.InterfaceNode;
import com.inprise.vbroker.compiler.ast.ModuleNode;
import com.inprise.vbroker.compiler.ast.NativeNode;
import com.inprise.vbroker.compiler.ast.Node;
import com.inprise.vbroker.compiler.ast.OperationNode;
import com.inprise.vbroker.compiler.ast.RepositoryNode;
import com.inprise.vbroker.compiler.ast.StructNode;
import com.inprise.vbroker.compiler.ast.Type;
import com.inprise.vbroker.compiler.ast.UnionNode;
import com.inprise.vbroker.compiler.ast.ValueBoxNode;
import com.inprise.vbroker.compiler.ast.ValueMemberNode;
import com.inprise.vbroker.compiler.ast.ValueNode;
import com.inprise.vbroker.compiler.backends.common.CommonOptions;
import com.inprise.vbroker.compiler.backends.depsolver.DepSolver;
import com.inprise.vbroker.compiler.backends.depsolver.DependencySpec;
import com.inprise.vbroker.compiler.util.BufferWriter;
import com.inprise.vbroker.compiler.util.ErrorReporter;
import com.inprise.vbroker.util.SimpleStringBuffer;
import java.io.File;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public abstract class GenericBackend {
    private static final boolean _trace = false;
    protected DependencySpec _depSpec;
    protected DepSolver _depSolver;
    protected DepSolver _topDepSolver;
    protected BufferWriter _bufferWriter;
    protected static final String LINE_SEP = System.getProperty("line.separator");
    protected static final char LINE_SEP_CHAR = LINE_SEP.charAt(0);
    protected static final String COMMA_LINE_SEP = ",".concat(String.valueOf(LINE_SEP));
    protected int _preferredLineWidth = 78;
    protected int _horizPos;
    private int _savedHorizPos;
    protected int _virtualCharCount;
    private int[] _virtualCountStack = new int[10];
    private int[] _realCountStack = new int[10];
    private int _conditionalStackDepth;
    private Stack _bufferPool = new Stack();
    public ErrorReporter _ER;
    protected static final String[] SPACES = new String[]{" ", " ", " ", " ", " ", " ", " ", " ", " "};
    protected RepositoryNode _repository;
    protected CommonOptions _options;
    protected int _rootFile;
    protected Stack _openFiles = new Stack();
    protected SimpleStringBuffer _outputBuffer;
    public SimpleStringBuffer Buffer = this._outputBuffer = new SimpleStringBuffer();
    private SimpleStringBuffer _formerBuffer;
    private SimpleStringBuffer _lineBreakBuffer = new SimpleStringBuffer();
    private SimpleStringBuffer _tmpBuffer = new SimpleStringBuffer();
    public Hashtable FileTable = new Hashtable();
    protected static final int NUM_SPACES_PER_INDENT = 2;
    public int Indent = 0;
    public String TabString = null;

    protected GenericBackend(RepositoryNode repository, DependencySpec depSpec, String rootFile, BufferWriter bufferWriter) {
        this._repository = repository;
        this._depSpec = depSpec;
        this._bufferWriter = bufferWriter;
        if (this._repository != null) {
            this._ER = this._repository._ER;
            this._rootFile = this._ER.setFile(rootFile);
        }
    }

    protected void _dispatch(ContainedNode node, String declarator) {
        int kind = node._kind;
        switch (kind) {
            case 7: {
                this.genOperation((OperationNode)node);
                break;
            }
            case 5: {
                this.genInterface((InterfaceNode)node);
                break;
            }
            case 2: {
                this.genAttribute((AttributeNode)node);
                break;
            }
            case 9: {
                this.genAlias((AliasNode)node);
                break;
            }
            case 4: {
                this.genException((ExceptionNode)node);
                break;
            }
            case 3: {
                this.genConstant((ConstantNode)node);
                break;
            }
            case 22: {
                this.genValueMember((ValueMemberNode)node);
                break;
            }
            case 20: {
                this.genValue((ValueNode)node);
                break;
            }
            case 21: {
                this.genValueBox((ValueBoxNode)node);
                break;
            }
            case 23: {
                this.genNative((NativeNode)node);
                break;
            }
            case 12: {
                this.genEnum((EnumNode)node, declarator);
                break;
            }
            case 10: {
                this.genStruct((StructNode)node, declarator);
                break;
            }
            case 11: {
                this.genUnion((UnionNode)node, declarator);
                break;
            }
            default: {
                this._ER.internalError(String.valueOf(new StringBuffer("unknown or invalid type ").append(Node.typeName(kind)).append(" (").append(kind).append(") in GeneraticBackend.dispatch()")));
            }
        }
    }

    protected void add(char c) {
        this.Buffer.append(c);
        ++this._horizPos;
        ++this._virtualCharCount;
    }

    protected void add(int i) {
        this.add(Integer.toString(i));
    }

    protected void add(String s) {
        int len = s.length();
        this.Buffer.append(s);
        this._horizPos += len;
        this._virtualCharCount += len;
    }

    protected void addln(char c) {
        this.Buffer.append(c);
        this.Buffer.append(LINE_SEP);
        this._horizPos = 0;
        this._virtualCharCount += 2;
    }

    protected void addln(int i) {
        this.addln(Integer.toString(i));
    }

    protected void addln(long l) {
        this.addln(Long.toString(l));
    }

    protected void addln(String s) {
        int len = s.length();
        this.Buffer.append(s);
        this.Buffer.append(LINE_SEP);
        this._horizPos = 0;
        this._virtualCharCount += len + 1;
    }

    protected void beginLineBreaking() {
        this._savedHorizPos = this._horizPos;
        this._lineBreakBuffer.reset();
        this._formerBuffer = this.Buffer;
        this.Buffer = this._lineBreakBuffer;
    }

    protected void beginModule(ModuleNode module) {
    }

    protected void beginRepository(RepositoryNode repository) {
    }

    protected void closeFile() {
        this.closeFile(true);
    }

    protected void closeFile(String origFilename, boolean overwriteIfDifferent) {
        if (this.Indent != 0) {
            if (this._ER._verbose) {
                this._ER.untranslatedMessage(String.valueOf(new StringBuffer("Bad Indent ").append(this.Indent).append("at close of file ").append(origFilename)));
            }
            this.Indent = 0;
        }
        String filename = this._options._rootDir != null ? String.valueOf(new StringBuffer(String.valueOf(this._options._rootDir)).append(File.separatorChar).append(origFilename)) : origFilename;
        Object o = this.FileTable.get(origFilename);
        if (o == null) {
            this._ER.fatal("Comp.BE.generatingNonExistent", new Object[]{filename});
        } else {
            if (o == Boolean.TRUE || o == Boolean.FALSE) {
                throw new RuntimeException("attempting to close previously closed file".concat(String.valueOf(filename)));
            }
            if (this._options._listFiles) {
                System.out.println(filename);
            }
            if (this._bufferWriter.write(filename, (SimpleStringBuffer)o, true, this._bufferPool, overwriteIfDifferent)) {
                this.FileTable.put(filename, Boolean.TRUE);
            } else {
                this.FileTable.put(filename, Boolean.FALSE);
            }
        }
    }

    protected void closeFile(boolean overwriteIfExist) {
        this.closeFile((String)this._openFiles.pop(), overwriteIfExist);
        if (!this._openFiles.empty()) {
            this.useFile((String)this._openFiles.peek());
        }
    }

    protected void closeModule(ModuleNode module) {
    }

    protected final void commaSepDefs(Vector defs, boolean useFullName) {
        int startPos = this._horizPos;
        int len = defs.size();
        for (int i = 0; i < len; ++i) {
            String name;
            ContainedNode c = (ContainedNode)defs.elementAt(i);
            String string = name = useFullName ? c._beFullName : c._beName;
            if (i == 0) {
                this.add(name);
                continue;
            }
            if (this._horizPos > startPos && this._horizPos + name.length() + 2 > this._preferredLineWidth) {
                this.add(",");
                this.newLine();
                this.indentTo(startPos);
            } else {
                this.add(", ");
            }
            this.add(name);
        }
    }

    protected final void commaSepList(Type type, Vector v) {
        int startPos = this._horizPos;
        int len = v.size();
        for (int i = 0; i < len; ++i) {
            String name = type.toLiteral(v.elementAt(i));
            if (i == 0) {
                this.add(name);
                continue;
            }
            if (this._horizPos > startPos && this._horizPos + name.length() + 2 > this._preferredLineWidth) {
                this.add(",");
                this.newLine();
                this.indentTo(startPos);
            } else {
                this.add(", ");
            }
            this.add(name);
        }
    }

    public void dispatch(ContainedNode node) {
        if (node._kind == 6) {
            ModuleNode module = (ModuleNode)node;
            this.beginModule(module);
            this.endModule(module);
        } else {
            this._dispatch(node, null);
        }
    }

    protected void dispatch(ContainedNode node, String declarator) {
        this._dispatch(node, declarator);
    }

    protected void endLineBreaking() {
        this.Buffer = this._formerBuffer;
        this._horizPos = this._savedHorizPos;
        boolean firstTime = true;
        String contents = this._lineBreakBuffer.toString();
        int len = contents.length();
        for (int i = 0; i < len; ++i) {
            char c = contents.charAt(i);
            if (c == ',') {
                c = contents.charAt(i + 1);
                while (i + 1 < len && (c == ' ' || c == '\n' || c == '\r' || c == '\t')) {
                    c = contents.charAt(++i + 1);
                }
                this._tmpBuffer.append(',');
                firstTime = this.lineBreakWord(firstTime);
                continue;
            }
            this._tmpBuffer.append(c);
        }
        this.lineBreakWord(firstTime);
    }

    protected void endModule(ModuleNode module) {
    }

    protected void endRepository(RepositoryNode repository) {
    }

    protected void ensureIndent() {
        if (this._horizPos == 0) {
            this.indent();
        }
    }

    protected void ensureNewLine() {
        if (this._horizPos != 0) {
            this.newLine();
        }
    }

    protected void finish() {
    }

    private final void finishNodes(DepSolver depSolver) {
        this._repository.finish(2);
        int len = depSolver._numDefinitions;
        for (int i = 0; i < len; ++i) {
            ContainedNode node = depSolver._definitions[i];
            int code = depSolver._codes[i];
            boolean result = node.finish(code);
            if (node.isContainer() && code == 6 || node._kind == 6 && code == 2 && !this._depSpec._modulesAreBreakable) {
                DepSolver.ContainerDepNode d = (DepSolver.ContainerDepNode)depSolver.idlDefn2DepNode(node, true);
                this.finishNodes(d.Subgraph);
            }
            if (result && (this._options._genInclFiles || node._fileNumber == this._rootFile)) continue;
            depSolver._definitions[i] = null;
        }
    }

    protected void forwardDeclareInterface(InterfaceNode intrface) {
    }

    protected void forwardDeclareValue(ValueNode value) {
    }

    protected void gen() {
        if (this._depSolver == this._topDepSolver) {
            this.beginRepository(this._repository);
        }
        int len = this._depSolver._numDefinitions;
        block8: for (int i = 0; i < len; ++i) {
            ContainedNode node = this._depSolver._definitions[i];
            int code = this._depSolver._codes[i];
            if (node == null) continue;
            switch (code) {
                case 6: {
                    this.dispatch(node, null);
                    continue block8;
                }
                case 4: {
                    this.openModule((ModuleNode)node);
                    continue block8;
                }
                case 5: {
                    this.closeModule((ModuleNode)node);
                    continue block8;
                }
                case 3: {
                    this.endModule((ModuleNode)node);
                    continue block8;
                }
                case 2: {
                    this.beginModule((ModuleNode)node);
                    continue block8;
                }
                case 1: {
                    if (node instanceof InterfaceNode) {
                        this.forwardDeclareInterface((InterfaceNode)node);
                        continue block8;
                    }
                    this.forwardDeclareValue((ValueNode)node);
                    continue block8;
                }
                default: {
                    this._ER.internalError(String.valueOf(new StringBuffer("invalid generation code (").append(this._depSolver._codes[i]).append(") from DepSolver")));
                }
            }
        }
        if (this._depSolver == this._topDepSolver) {
            this.endRepository(this._repository);
        }
    }

    protected void genAlias(AliasNode alias) {
    }

    protected void genAttribute(AttributeNode attribute) {
    }

    protected void genConstant(ConstantNode constant) {
    }

    protected void genContents(ContainerNode c) {
        DepSolver.ContainerDepNode d = (DepSolver.ContainerDepNode)this._depSolver.idlDefn2DepNode((Node)((Object)c), true);
        DepSolver tmp = this._depSolver;
        this._depSolver = d.Subgraph;
        this.gen();
        this._depSolver = tmp;
    }

    protected void genEnum(EnumNode enumNode, String declarator) {
    }

    protected void genException(ExceptionNode exception) {
    }

    protected void genInterface(InterfaceNode intrface) {
    }

    protected void genNative(NativeNode nativ) {
    }

    protected void genOperation(OperationNode operation) {
    }

    protected void genStruct(StructNode struct, String declarator) {
    }

    protected void genUnion(UnionNode union, String declarator) {
    }

    protected void genValue(ValueNode value) {
    }

    protected void genValueBox(ValueBoxNode valueBox) {
    }

    protected void genValueMember(ValueMemberNode valueMember) {
    }

    public void generate(ContainerNode container) {
        Object finishParameterizedTypesTimer = null;
        Object depSolverTimer = null;
        Object codegenTimer = null;
        this._topDepSolver = this._depSolver = new DepSolver(this._depSpec, container);
        this.initialize();
        this.finishNodes(this._depSolver);
        this.gen();
        this.finish();
    }

    protected String getCurrentIndent() {
        if (this.TabString == null) {
            if (this.Indent == 0) {
                return "";
            }
            if (this.Indent == 1) {
                return "  ";
            }
            if (this.Indent == 2) {
                return "    ";
            }
            String ret = "";
            for (int i = 0; i < this.Indent * 2; ++i) {
                ret = String.valueOf(ret).concat(String.valueOf(' '));
            }
            return ret;
        }
        return this.TabString;
    }

    protected void indent() {
        if (this.TabString == null) {
            int n = 2 * this.Indent;
            this.Buffer.append(' ', n);
            this._horizPos += n;
        } else {
            int len = this.TabString.length();
            this.Buffer.append(this.TabString);
            this._horizPos += len;
        }
    }

    protected void indentTo(int numSpaces) {
        this.Buffer.append(' ', numSpaces);
        this._horizPos += numSpaces;
    }

    protected void initialize() {
        this._options = this._repository._options;
        this._repository.finishParameterizedTypes();
    }

    protected final boolean isForwardDeclared(InheritableNode node) {
        return this._depSolver.isForwardDeclared(node);
    }

    private final boolean lineBreakWord(boolean firstTime) {
        if (this._tmpBuffer.length() > 0) {
            String word = this._tmpBuffer.toString();
            this._tmpBuffer.reset();
            if (firstTime) {
                this.add(word);
            } else if (this._horizPos + 1 + word.length() > this._preferredLineWidth && this._horizPos > this._savedHorizPos) {
                this.newLine();
                this.indentTo(this._savedHorizPos);
                this.add(word);
            } else {
                this.add(' ');
                this.add(word);
            }
            return false;
        }
        return firstTime;
    }

    protected void newLine() {
        this.Buffer.append(LINE_SEP);
        this._horizPos = 0;
        ++this._virtualCharCount;
    }

    protected void openModule(ModuleNode module) {
    }

    protected final void popConditional(int unconditionalLength) {
        --this._conditionalStackDepth;
        int previousVirtualCount = this._virtualCountStack[this._conditionalStackDepth];
        int previousBufferPos = this._realCountStack[this._conditionalStackDepth];
        int actualLength = this._virtualCharCount - previousVirtualCount;
        if (actualLength <= unconditionalLength) {
            this.Buffer.reset(previousBufferPos);
            this._virtualCharCount = previousVirtualCount;
        }
    }

    protected final void print(char c) {
        this.indent();
        this.Buffer.append(c);
        ++this._horizPos;
        ++this._virtualCharCount;
    }

    protected final void print(int i) {
        this.print(Integer.toString(i));
    }

    protected void print(String s) {
        this.indent();
        int len = s.length();
        this.Buffer.append(s);
        this._horizPos += len;
        this._virtualCharCount += len;
    }

    protected final void println(char c) {
        this.indent();
        this.Buffer.append(c);
        this.Buffer.append(LINE_SEP);
        this._horizPos = 0;
        this._virtualCharCount += 2;
    }

    protected void println(String s) {
        this.indent();
        int len = s.length();
        this.Buffer.append(s);
        this.Buffer.append(LINE_SEP);
        this._horizPos = 0;
        this._virtualCharCount += len + 1;
    }

    protected final void pushConditional() {
        this._virtualCountStack[this._conditionalStackDepth] = this._virtualCharCount;
        this._realCountStack[this._conditionalStackDepth] = this.Buffer.length();
        ++this._conditionalStackDepth;
    }

    protected void useFile(String filename) {
        this.useFile(filename, 32768);
    }

    protected void useFile(String filename, int sizeHint) {
        Object o = this.FileTable.get(filename);
        if (o == null) {
            if (this._bufferPool.size() > 0) {
                this.Buffer = (SimpleStringBuffer)this._bufferPool.pop();
                this.Buffer.ensureCapacity(sizeHint);
            } else {
                this.Buffer = new SimpleStringBuffer(sizeHint);
            }
            this.FileTable.put(filename, this.Buffer);
            this._openFiles.push(filename);
        } else {
            if (o == Boolean.FALSE) {
                String printName = filename;
                if (this._options._rootDir != null) {
                    printName = String.valueOf(new StringBuffer(String.valueOf(this._options._rootDir)).append(File.separatorChar).append(filename));
                }
                throw new RuntimeException(String.valueOf(new StringBuffer("attempt to re-open file ").append(printName).append(" after closing it")));
            }
            this.Buffer = (SimpleStringBuffer)o;
        }
    }
}

